//%attributes = {"publishedSql":true}
// Method: _date KEYSTROKE(Self:P (date type) )
// 2001.01.18-20:46:29 / Pasi Mankinen
// © Copyright 2001 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------


// Project Method: HandleDate (->date field or variable)

// Searching for answers? Be sure to check out the "About..." menu located in the
// Apple menu (Macintosh) or the Help menu (Windows). There you can find online
// help for this example database, as well as a listing of numerous 4D resources
// available to you.

// Method created by Tom Dillon, DataCraft

// Function: Interprets what has been entered as a date
//    And checks to see if a "function" key is hit and acts accordingly

// Place in the object method of a date field or variable
//   HandleDate(Self)

// Required: Set the date field's On Before Keystroke and
//   On Data Change events to on.


C_DATE:C307($_date_Date; $_date_CurrentDate)
C_POINTER:C301($1; $_date_DateFieldPtr)
_O_C_STRING:C293(1; $_date_Keystroke)

$_date_DateFieldPtr:=$1

Case of 
	: (Is nil pointer:C315($_date_DateFieldPtr))
		TRACE:C157  //use Self, not Self->
	: (Type:C295($_date_DateFieldPtr->)#Is date:K8:7)
		TRACE:C157  //not a date var or field   
		
	: (Form event code:C388=On Data Change:K2:15)  // Interpret the entry
		$_date_DateFieldPtr->:=_date_StrToDate(Get edited text:C655)
		
	: (Form event code:C388=On Before Keystroke:K2:6)
		
		$_date_Keystroke:=Keystroke:C390
		$_date_CurrentDate:=_date Current(kTrue)
		Case of   // Check to see if a "function" key is hit
			: ($_date_Keystroke="+")  // Add a day
				$_date_Date:=_date_StrToDate(Get edited text:C655)
				If ($_date_Date=!00-00-00!)
					$_date_Date:=$_date_CurrentDate
				End if 
				$_date_DateFieldPtr->:=_date Add($_date_Date; 0; 0; 1)
				FILTER KEYSTROKE:C389("")
				
			: ($_date_Keystroke="-")  // Subtract a day
				$_date_Date:=_date_StrToDate(Get edited text:C655)
				If ($_date_Date=!00-00-00!)
					$_date_Date:=$_date_CurrentDate
				End if 
				$_date_DateFieldPtr->:=_date Add($_date_Date; 0; 0; -1)
				FILTER KEYSTROKE:C389("")
				
			: ($_date_Keystroke="T")  // Today
				$_date_DateFieldPtr->:=$_date_CurrentDate
				FILTER KEYSTROKE:C389("")
				
			: ($_date_Keystroke="M")  // First of Month
				$_date_Date:=_date_StrToDate(Get edited text:C655)
				If ($_date_Date=!00-00-00!)
					$_date_Date:=$_date_CurrentDate
				End if 
				$_date_DateFieldPtr->:=_date Add($_date_Date; 0; 0; -Day of:C23($_date_Date)+1)
				FILTER KEYSTROKE:C389("")
				
			: ($_date_Keystroke="H")  // End of montH
				$_date_Date:=_date_StrToDate(Get edited text:C655)
				If ($_date_Date=!00-00-00!)
					$_date_Date:=$_date_CurrentDate
				End if 
				$_date_DateFieldPtr->:=_date Add($_date_Date; 0; 1; -Day of:C23($_date_Date))
				FILTER KEYSTROKE:C389("")
				
			: ($_date_Keystroke="Y")  // First of Year
				$_date_Date:=_date_StrToDate(Get edited text:C655)
				If ($_date_Date=!00-00-00!)
					$_date_Date:=$_date_CurrentDate
				End if 
				$_date_DateFieldPtr->:=Date:C102("1/1/"+String:C10(Year of:C25($_date_Date)))
				FILTER KEYSTROKE:C389("")
				
			: ($_date_Keystroke="R")  // End of yeaR
				$_date_Date:=_date_StrToDate(Get edited text:C655)
				If ($_date_Date=!00-00-00!)
					$_date_Date:=$_date_CurrentDate
				End if 
				$_date_DateFieldPtr->:=Date:C102("1/1/"+String:C10(Year of:C25($_date_Date)+1))-1
				FILTER KEYSTROKE:C389("")
				
		End case 
		
End case 
